; Mouse2.asm - displays mouse buttons pressed and co-ordinates
;
; This second version shows how mouse messages can be captured
; outside the current window's client area, and also provides
; code for the exercise in Mouse1.asm
;
; Whilst this is extremely similar to Mouse1.asm, to make new
; code stand out I've only placed comments where things are
; different from Mouse1.asm. You should understand Mouse1.asm
; before studying this file
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Mouse reader',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	ddstatic	_ddX, _ddY
	endlocals
	TEXTlocal	_szOutputString, '                                       ',0
	;
	; _szOutputMove holds the current coords string to paint
	;
	TEXTlocal	_szOutputMove, '                                         ',0
	;
	CallbackPrologue
	;
	switch .message
		case WM_PAINT
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			;
			; Draw the output strings onto the window, to stop the two strings
			; obscuring each other I've aligned one to the top of the window
			;
			sc DrawText, ._hdc, ._szOutputString, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc DrawText, ._hdc, ._szOutputMove, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_TOP
			sc EndPaint, .hwnd, ._ps
			xor	eax, eax
			break
		case WM_LBUTTONDOWN
			;
			; Normally, mouse messages are sent to the window the mouse is
			; currently over, but we might not want this - for example if you
			; hold down the button in Mouse1, move the mouse out of the window
			; and release the button, you won't see this registered in the
			; window as it doesn't know about it.
			;
			; We can tell Windows to not do this, and instead send us all
			; the mouse messages by calling SetCapture. This takes one
			; parameter - the window handle - and then captures all mouse
			; messages and sends them to us. We have to be careful to
			; stop this behaviour (by releasing the capture) when the
			; button is released (ie in WM_LBUTTONUP).
			;
			sc SetCapture, .hwnd
			%macro SetMessage 1
				mov	ecx, .lParam		; loword=x, hiword=y
				movsx	eax, cx			; get loword in ax
				shr	ecx, 16
				movsx	ebx, cx			; get hiword in bx
				mov	._ddX, eax
				mov	._ddY, ebx
				sc wvsprintf, ._szOutputString, %1, .._ddX
				sc InvalidateRect, .hwnd, NULL, TRUE
				xor	eax, eax
			%endmacro
			;
			; SetMessageMove is identical to SetMessage except for
			; the buffer it writes to
			;
			%macro SetMessageMove 1
				mov	ecx, .lParam		; loword=x, hiword=y
				movsx	eax, cx			; get loword in ax
				shr	ecx, 16
				movsx	ebx, cx			; get hiword in bx
				mov	._ddX, eax
				mov	._ddY, ebx
				sc wvsprintf, ._szOutputMove, %1, .._ddX
				sc InvalidateRect, .hwnd, NULL, TRUE
				xor	eax, eax
			%endmacro
			TEXTlocal _szLeftDown, 'Left-button pressed, X=%i, Y=%i',0
			SetMessage ._szLeftDown
			break
		case WM_LBUTTONUP
			;
			; We need to release the capture once the button has been
			; released. There is a corresponding capture / release for
			; the right button also.
			;
			sc ReleaseCapture
			TEXTlocal _szLeftUp, 'Left-button released, X=%i, Y=%i',0
			SetMessage ._szLeftUp
			break
		case WM_LBUTTONDBLCLK
			TEXTlocal _szLeftDouble, 'Left double-click, X=%i, Y=%i',0
			SetMessage ._szLeftDouble
			break
		case WM_RBUTTONDOWN
			sc SetCapture, .hwnd
			TEXTlocal _szRightDown, 'Right-button pressed, X=%i, Y=%i',0
			SetMessage ._szRightDown
			break
		case WM_RBUTTONUP
			sc ReleaseCapture
			TEXTlocal _szRightUp, 'Right-button released, X=%i, Y=%i',0
			SetMessage ._szRightUp
			break
		case WM_RBUTTONDBLCLK
			TEXTlocal _szRightDouble, 'Right double-click, X=%i, Y=%i',0
			SetMessage ._szRightDouble
			break
		case WM_MOUSEMOVE
			;
			; This message is sent whenever the mouse moves. Well, strictly speaking
			; that isn't quite true - the speed they're sent at depends on how good
			; the hardware is and how quick your program is at processing the
			; messages. Like the other mouse messages, lParam in the message holds
			; the current mouse coordinates and wParam holds the current button
			; and shift/control key states. All we do is generate a string for
			; display and then tell Windows to redraw the screen. In terms of
			; efficiency, it's not good to redraw the whole client area, but for
			; now, we might as well keep things simple
			;
			TEXTlocal _szMove, 'X=%i, Y=%i',0
			SetMessageMove ._szMove
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax,eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc

[section .bss]

[section .data]
